define([
    'underscore',
    'marionette',
    'text!modules/new-appointment-request/views/direct/preferred-date/templates/selected-date-time.html',
],
function(_, Marionette, template) {
    'use strict';

    return Marionette.View.extend({
        tagName: 'p',
        className: 'appointment-details-selected-date-time-slot',
        template: template,
        modelEvents: {'change:dateTime': 'render validateDateTime'},
        serializeData: function() {
            var data = {};

            if (this.model) {
                data = this.model.toJSON();
                if (_.isUndefined(data.dateTime)) {
                    data.dateTime = '';
                }
            } else if (this.collection) {
                data = {items: this.collection.toJSON()};
            }

            return data;
        },
        onDomRefresh: function() {
            this.addFormValidationRules(this.$el.find('input'));
        },
        addFormValidationRules: function($input) {
            var rules = {};

            rules.required = this.model.get('required');
            rules.formattedDate = this.model.has('desiredDate');
            rules.messages = {
                required: 'Select Date/Time field is required.',
                formattedDate: 'Select Date/Time field is required.',
            };

            $input.rules('add', rules);
        },
        validateDateTime: function() {
            if (this.model.has('dateTime')) {
                this.$el.find('input').valid();
            }
        },
    });
});
